clc
clear all
close all

%% Read Data
[A,words] = xlsread('WEBdatacopy.xls');
words=words(1,1:2:end);
[row, col] = size(A);
MFsIA=zeros(col/2,9);
MFsEIA=zeros(col/2,9);
numIA=zeros(col/2,5);
numEIA=zeros(col/2,7);
FSIA=zeros(row,2,col/2);
FSEIA=zeros(row,2,col/2);

for i=1:col/2
    L = A(1:row, 2*i-1);  %% Left end-points for interval data.
    R = A(1:row, 2*i);    %% Right end-points for interval data.
    [MFsIA(i,:),numIA(i,:),shapeIA(i),FSL,FSR]=IA(L,R);
    FSIA(1:length(FSL),1,i)=FSL;
    FSIA(1:length(FSR),2,i)=FSR;
    [MFsEIA(i,:),numEIA(i,:),shapeEIA(i),FSL,FSR]=EIA(L,R);
    FSEIA(1:length(FSL),1,i)=FSL;
    FSEIA(1:length(FSR),2,i)=FSR;
    Cs(i)=centroidIT2(MFsEIA(i,:));
end

%% Sort the MFs in ascending order according to the center of centroids
[Cs,index]=sort(Cs);  % Sort the centers of the centroids
MFsEIA=round(100*MFsEIA(index,:))/100;     % Reorder the MFs
MFsIA=round(100*MFsIA(index,:))/100;     % Reorder the MFs
words=words(index); % Reorder the names of words
numIA=numIA(index,:);
numEIA=numEIA(index,:);
FSIA=FSIA(:,:,index);
FSEIA=FSEIA(:,:,index);
shapeIA=shapeIA(index);
shapeEIA=shapeEIA(index);
% 
% %% Plot embedded T1 FSs, IA
% figure
% set(gcf,'DefaulttextFontName','times new roman');
% set(gcf,'DefaultaxesFontName','times new roman');
% set(gcf,'DefaulttextFontAngle','italic');
% for i=1:32
%     subplot(8,6,2*floor((i-1)/4)+i);
%     L=FSIA(:,1,i); R=FSIA(:,2,i);
%     if shapeIA(i)==1
%         plot([L R],[1 0],'linewidth',.5);
%     elseif shapeIA(i)==3
%         plot([L R],[0 1],'linewidth',.5);
%     else plot([L mean([L,R],2) R],[0 1 0],'linewidth',.5);
%     end
%     hold on
%     plot(MFsIA(i,[1:4 8:-1:5]),[0 1 1 0 0 MFsIA(i,[9 9]) 0],'k','linewidth',1.5);
%     title(words(i),'fontsize',9);
%     set(gca,'YTick',[]);
%     set(gca,'XTick',[]);
%     axis([0 10 0 1]);
% end
% saveas(gcf,'WEBIA.eps','psc2');
% 
% %% Plot embedded T1 FSs, EIA
% figure
% set(gcf,'DefaulttextFontName','times new roman');
% set(gcf,'DefaultaxesFontName','times new roman');
% set(gcf,'DefaulttextFontAngle','italic');
% for i=1:32
%     subplot(8,6,2*floor((i-1)/4)+i);
%     L=FSEIA(:,1,i); R=FSEIA(:,2,i);
%     if shapeEIA(i)==1
%         plot([L R],[1 0],'linewidth',.5);
%     elseif shapeEIA(i)==3
%         plot([L R],[0 1],'linewidth',.5);
%     else plot([L mean([L,R],2) R],[0 1 0],'linewidth',.5);
%     end
%     hold on
%     plot(MFsEIA(i,[1:4 8:-1:5]),[0 1 1 0 0 MFsEIA(i,[9 9]) 0],'k','linewidth',1.5);
%     title(words(i),'fontsize',9);
%     set(gca,'YTick',[]);
%     set(gca,'XTick',[]);
%     axis([0 10 0 1]);
% end
% saveas(gcf,'WEBEIA.eps','psc2');
% 
% %% Plot the ordered interval type-2 word models
% figure
% set(gcf,'DefaulttextFontName','times new roman');
% set(gcf,'DefaultaxesFontName','times new roman');
% set(gcf,'DefaulttextFontAngle','italic');
% for i=1:32
%     subplot(8,6,2*floor((i-1)/4)+i);
%     plotIT2(MFsEIA(i,:));
%     hold on
%     plot(MFsIA(i,[1:4 8:-1:5]),[0 1 1 0 0 MFsIA(i,[9 9]) 0],'r-','linewidth',1);
%     title(words(i),'fontsize',9);
%     set(gca,'YTick',[]);
%     set(gca,'XTick',[]);
%     axis([0 10 0 1]);
% end
% saveas(gcf,'WEB.eps','psc2');

%% Plot only five word models
figure
set(gcf,'DefaulttextFontName','times new roman');
set(gcf,'DefaultaxesFontName','times new roman');
set(gcf,'DefaulttextFontAngle','italic');
subset=[3 9 12 24 27];
for i=1:5
    subplot(6,5,i);
    plotIT2(MFsIA(subset(i),:));     hold on
    title(words(subset(i)),'fontsize',14);
    set(gca,'YTick',[]);
    set(gca,'XTick',[]);
    axis([0 10 0 1]);
end
saveas(gcf,'IA5.eps','psc2');

figure
set(gcf,'DefaulttextFontName','times new roman');
set(gcf,'DefaultaxesFontName','times new roman');
set(gcf,'DefaulttextFontAngle','italic');
for i=1:5
    subplot(6,5,i);
    plotIT2(MFsEIA(subset(i),:));     hold on
    title(words(subset(i)),'fontsize',14);
    set(gca,'YTick',[]);
    set(gca,'XTick',[]);
    axis([0 10 0 1]);
end
saveas(gcf,'EIA5.eps','psc2');
