%% Personal FOUs
clear all
close all
clc

% almost impossible
almostPossible = [.02 .07 .1 .12; 0 .023 .078 .096; .02 .03 .12 .14; ...  
    0 .01 .02 .05; 0 .02 .05 .07; 0 0 .01 .05; 0 .01 .02 .04; ... 
    .01 .03 .04 .08; 0 .05 .08 .12; .03 .05 .06 .09];

% improbable
improbable = [.2 .27 .32 .35; .225 .286 .392 .411; .25 .27 .38 .42; ... 
    .05 .1 .25 .39; 0 .1 .2 .3; 0 .05 .075 .1; .04 .08 .15 .25; ... 
    .1 .16 .25 .33; .1 .15 .23 .28; .08 .14 .19 .25];

% Doubtful
doubtful = [.12 .2 .26 .29; .097 .135 .219 .243; .2 .26 .31 .34; ... 
    .2 .3 .35 .47; .1 .3 .4 .5; .2 .3 .35 .4; .18 .33 .34 .42; ... 
    .02 .06 .14 .18; .25 .28 .37 .42; .2 .28 .3 .37];

% unlikely
unlikely = [.33 .37 .43 .49; .265 .299 .409 .444; .33 .35 .55 .59; ... 
    .2 .23 .3 .35; 0 .2 .3 .45; .1 .2 .2 .3; .18 .23 .28 .31; ... 
    .1 .2 .25 .45; .2 .3 .33 .38; .1 .22 .25 .38];

% tossup
tossup = [.48 .48 .52 .55; .363 .398 .509 .534; .42 .45 .58 .6; ... 
    .3 .5 .7 .9; .45 .5 .5 .55; .35 .45 .55 .6; .25 .45 .55 .85; ... 
    .44 .48 .52 .56; .35 .45 .52 .61; .4 .47 .52 .59];

% Possible
possible = [.53 .59 .63 .69; .46 .499 .589 .601; .41 .49 .57 .68; ... 
    .55 .6 .65 .7; .2 .3 .5 1; .35 .45 .55 .65; .58 .62 .66 .78; ... 
    .04 .4 .64 .7; .4 .5 .63 .73; .5 .6 .65 .75];

% Likely
likely = [.7 .78 .83 .88; .657 .681 .768 .833; .7 .77 .82 .88; ... 
    .6 .65 .8 .9; .5 .7 .7 .9; .65 .7 .75 .8; .5 .6 .62 .75; ... 
    .65 .75 .82 .88; .55 .65 .72 .78; .52 .6 .75 .8];

% Probable
probable = [.86 .89 .93 .96; .798 .812 .872 .902; .57 .63 .69 .75; ... 
    .4 .5 .5 .6; .6 .7 .75 .9; .5 .6 .7 .78; .61 .65 .78 .89; ... 
    .72 .8 .82 .9; .6 .7 .75 .8; .78 .8 .83 .88];

% Good chance
goodChance = [.6 .61 .79 .79; .503 .531 .677 .692; .62 .66 .76 .84; ... 
    .75 .85 .85 .9; .7 .8 .8 1; .7 .75 .8 .85; .78 .83 .84 .92; ... 
    .6 .66 .8 .92; .83 .9 .93 .96; .7 .75 .85 .9];

% Almost certain
almostCertain = [.94 .96 1 1; .879 .912 .973 .991; .8 .89 .9 .97; ... 
    .85 .92 .95 1; .7 .8 .9 1; .95 .97 .98 1; .9 .96 .98 1; ... 
    .92 .96 .97 .99; .88 .94 .96 1; .9 .92 .97 .99];

%% generate random end points according to uniform distributions
%%% almost impossible
% loop through 10 subjects
almostImpossibleFOUs = zeros(10, 9);
for s = 1 : 10
    L = random('unif', almostPossible(s, 1), almostPossible(s, 2), 50, 1);
    R = random('unif', almostPossible(s, 3), almostPossible(s, 4), 50, 1);
    
    % remove NANs
    L = removeNAN(L);
    R = removeNAN(R);

    [almostImpossibleFOUs(s, :), num, shape, LL, RR] = HMWithoutExtensiveRemovalProbability(L, R); %% Map into an IT2 FS
end

%%% improbable
% loop through 10 subjects
improbableFOUs = zeros(10, 9);
for s = 1 : 10
    L = random('unif', improbable(s, 1), improbable(s, 2), 50, 1);
    R = random('unif', improbable(s, 3), improbable(s, 4), 50, 1);
    
    % remove NANs
    L = removeNAN(L);
    R = removeNAN(R);

    [improbableFOUs(s, :), num, shape, LL, RR] = HMWithoutExtensiveRemovalProbability(L, R); %% Map into an IT2 FS
end

%%% Doubtful
% loop through 10 subjects
doubtfulFOUs = zeros(10, 9);
for s = 1 : 10
    L = random('unif', doubtful(s, 1), doubtful(s, 2), 50, 1);
    R = random('unif', doubtful(s, 3), doubtful(s, 4), 50, 1);
    
    % remove NANs
    L = removeNAN(L);
    R = removeNAN(R);

    [doubtfulFOUs(s, :), num, shape, LL, RR] = HMWithoutExtensiveRemovalProbability(L, R); %% Map into an IT2 FS
end

%%% unlikely
% loop through 10 subjects
unlikelyFOUs = zeros(10, 9);
for s = 1 : 10
    L = random('unif', unlikely(s, 1), unlikely(s, 2), 50, 1);
    R = random('unif', unlikely(s, 3), unlikely(s, 4), 50, 1);
    
    % remove NANs
    L = removeNAN(L);
    R = removeNAN(R);

    [unlikelyFOUs(s, :), num, shape, LL, RR] = HMWithoutExtensiveRemovalProbability(L, R); %% Map into an IT2 FS
end

%%% tossup
% loop through 10 subjects
tossupFOUs = zeros(10, 9);
for s = 1 : 10
    L = random('unif', tossup(s, 1), tossup(s, 2), 50, 1);
    R = random('unif', tossup(s, 3), tossup(s, 4), 50, 1);
    
    % remove NANs
    L = removeNAN(L);
    R = removeNAN(R);

    [tossupFOUs(s, :), num, shape, LL, RR] = HMWithoutExtensiveRemovalProbability(L, R); %% Map into an IT2 FS
end

%%% possible
% loop through 10 subjects
possibleFOUs = zeros(10, 9);
for s = 1 : 10
    L = random('unif', possible(s, 1), possible(s, 2), 50, 1);
    R = random('unif', possible(s, 3), possible(s, 4), 50, 1);
    
    % remove NANs
    L = removeNAN(L);
    R = removeNAN(R);

    [possibleFOUs(s, :), num, shape, LL, RR] = HMWithoutExtensiveRemovalProbability(L, R); %% Map into an IT2 FS
end

%%% likely
% loop through 10 subjects
likelyFOUs = zeros(10, 9);
for s = 1 : 10
    L = random('unif', likely(s, 1), likely(s, 2), 50, 1);
    R = random('unif', likely(s, 3), likely(s, 4), 50, 1);
    
    % remove NANs
    L = removeNAN(L);
    R = removeNAN(R);

    [likelyFOUs(s, :), num, shape, LL, RR] = HMWithoutExtensiveRemovalProbability(L, R); %% Map into an IT2 FS
end

%%% probable
% loop through 10 subjects
probableFOUs = zeros(10, 9);
for s = 1 : 10
    L = random('unif', probable(s, 1), probable(s, 2), 50, 1);
    R = random('unif', probable(s, 3), probable(s, 4), 50, 1);
    
    % remove NANs
    L = removeNAN(L);
    R = removeNAN(R);

    [probableFOUs(s, :), num, shape, LL, RR] = HMWithoutExtensiveRemovalProbability(L, R); %% Map into an IT2 FS
end

%%% goodChance
% loop through 10 subjects
goodChanceFOUs = zeros(10, 9);
for s = 1 : 10
    L = random('unif', goodChance(s, 1), goodChance(s, 2), 50, 1);
    R = random('unif', goodChance(s, 3), goodChance(s, 4), 50, 1);
    
    % remove NANs
    L = removeNAN(L);
    R = removeNAN(R);

    [goodChanceFOUs(s, :), num, shape, LL, RR] = HMWithoutExtensiveRemovalProbability(L, R); %% Map into an IT2 FS
end

%%% almostCertain
% loop through 10 subjects
almostCertainFOUs = zeros(10, 9);
for s = 1 : 10
    L = random('unif', almostCertain(s, 1), almostCertain(s, 2), 50, 1);
    R = random('unif', almostCertain(s, 3), almostCertain(s, 4), 50, 1);
    
    % remove NANs
    L = removeNAN(L);
    R = removeNAN(R);

    [almostCertainFOUs(s, :), num, shape, LL, RR] = HMWithoutExtensiveRemovalProbability(L, R); %% Map into an IT2 FS
end


%% Plot FOUs
figure
set(gcf,'DefaulttextFontName','times new roman');
set(gcf,'DefaultaxesFontName','times new roman');
set(gcf,'DefaulttextFontAngle','italic');

allPersonalFOUs = [almostImpossibleFOUs; improbableFOUs; doubtfulFOUs; ...
    unlikelyFOUs; tossupFOUs; possibleFOUs; likelyFOUs; probableFOUs; ... 
    goodChanceFOUs; almostCertainFOUs];

pos = [1, 2, 3, 6, 7, 8, 11, 12, 13, 16, 17, 18, 21, 22, 23, 26, 27, 28];

for i = 1 : 10
    for j = 1 : 10
        subplot(10, 10, (i - 1) * 10 + j);
        myplotIT23(allPersonalFOUs((j - 1) * 10 + i,:));
        set(gca,'YTick',[]);
        set(gca,'XTick',[]);
        axis([0 1 0 1]);
    end
end