function myplotIT23(xUMF)

A=xUMF;
domain=[A(1), A(4)];
xUMF=linspace(domain(1),domain(2),1000);
if A(4)< A(3) + 10 ^ -5
    A(4) = A(3) + 10^ -5;
end

if A(8)< A(7) + 10 ^ -5
    A(8) = A(7) + 10^ -5;
end
xLMF=xUMF;

uUMF=trapmf(xUMF,A(1:4));
uLMF=trapmf(xLMF,A(5:8)) * A(9);

if A(1) == 0 && A(2) == 0
    shape = 1;
elseif A(3) == 10 && A(4) == 10
    shape = 3;
else
    shape = 2;
end


fill([xUMF xLMF(end:-1:1)],[uUMF uLMF(end:-1:1)],[0.9 0.9 0.9]);
hold on
plot([xUMF xLMF(end:-1:1)],[uUMF uLMF(end:-1:1)],'k-','linewidth',2);

if shape == 1  % left shoulder
    highlight = [0, A(3)];
elseif shape == 2 % interior
    highlight = [A(2), A(3)];
elseif shape == 3 % right shoulder
    highlight = [A(2), 1];
end

line(highlight, [1, 1], 'LineWidth', 4, 'Color', 'k')

if ((abs(A(3) - A(4)) < 10^-3) && (shape == 1))
    line([A(3), A(3)], [0, 1], 'LineWidth', 2, 'Color', 'k')
end

if ((abs(A(1) - A(2)) < 10^-3) && (shape == 3))
    line([A(1), A(1)], [0, 1], 'LineWidth', 2, 'Color', 'k')
end

if ((abs(A(1) - A(2)) < 10^-3) && (shape == 2))
    line([A(1), A(1)], [0, 1], 'LineWidth', 2, 'Color', 'k')
end
if ((abs(A(3) - A(4)) < 10^-3) && (shape == 2))
    line([A(3), A(3)], [0, 1], 'LineWidth', 2, 'Color', 'k')
end
domain = [0, 1];
axis([domain 0 1.1]);

